/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.playsolo.manager;

import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import ws.hypha.playsolo.PlaySoloPlugin;
import ws.hypha.playsolo.data.PlaySoloManager;

public class PlayerVisibilityManager {
    private final PlaySoloPlugin plugin;
    private final PlaySoloManager playSoloManager;

    public PlayerVisibilityManager(PlaySoloPlugin plugin, PlaySoloManager playSoloManager) {
        this.plugin = plugin;
        this.playSoloManager = playSoloManager;
    }

    public void updateVisibilityForPlayer(Player player) {
        for (Player otherPlayer : Bukkit.getOnlinePlayers()) {
            if (player.equals((Object)otherPlayer)) continue;
            this.updateVisibilityBetween(player, otherPlayer);
        }
    }

    public void updateVisibilityForAllPlayers() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.updateVisibilityForPlayer(player);
        }
    }

    public void updateVisibilityBetween(Player p1, Player p2) {
        boolean p1IsSolo = this.playSoloManager.isSolo(p1);
        boolean p2IsSolo = this.playSoloManager.isSolo(p2);
        boolean p1HasBypass = p1.hasPermission("playsolo.bypass");
        boolean p2HasBypass = p2.hasPermission("playsolo.bypass");
        if (p1HasBypass || p2HasBypass) {
            p1.showPlayer((Plugin)this.plugin, p2);
            p2.showPlayer((Plugin)this.plugin, p1);
            return;
        }
        if (p1IsSolo || p2IsSolo) {
            p1.hidePlayer((Plugin)this.plugin, p2);
            p2.hidePlayer((Plugin)this.plugin, p1);
        } else {
            p1.showPlayer((Plugin)this.plugin, p2);
            p2.showPlayer((Plugin)this.plugin, p1);
        }
    }
}

