/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.playsolo.listeners;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import ws.hypha.playsolo.data.PlaySoloManager;
import ws.hypha.playsolo.data.PlaySoloMode;
import ws.hypha.playsolo.manager.PlayerVisibilityManager;

public class PlayerConnectionListener
implements Listener {
    private final PlaySoloManager playSoloManager;
    private final PlayerVisibilityManager visibilityManager;

    public PlayerConnectionListener(PlaySoloManager playSoloManager, PlayerVisibilityManager visibilityManager) {
        this.playSoloManager = playSoloManager;
        this.visibilityManager = visibilityManager;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.playSoloManager.loadPlayer(player);
        if (player.hasPermission("playsolo.force") && !this.playSoloManager.isSolo(player)) {
            this.playSoloManager.setSoloMode(player, PlaySoloMode.ON);
        }
        this.visibilityManager.updateVisibilityForPlayer(player);
        event.joinMessage(null);
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            if (!onlinePlayer.canSee(player)) continue;
            onlinePlayer.sendMessage(Component.text((String)(player.getName() + " joined the game")).color((TextColor)NamedTextColor.YELLOW));
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        event.quitMessage(null);
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            if (!onlinePlayer.canSee(player)) continue;
            onlinePlayer.sendMessage(Component.text((String)(player.getName() + " left the game")).color((TextColor)NamedTextColor.YELLOW));
        }
        this.playSoloManager.unloadPlayer(player);
    }
}

