/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.playsolo.listeners;

import java.util.Iterator;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import ws.hypha.playsolo.data.PlaySoloManager;
import ws.hypha.playsolo.data.PlaySoloMode;

public class PlayerChatListener
implements Listener {
    private final PlaySoloManager playSoloManager;

    public PlayerChatListener(PlaySoloManager playSoloManager) {
        this.playSoloManager = playSoloManager;
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player sender = event.getPlayer();
        PlaySoloMode senderMode = this.playSoloManager.getSoloMode(sender);
        if (sender.hasPermission("playsolo.bypass")) {
            return;
        }
        if (senderMode == PlaySoloMode.ON) {
            sender.sendMessage("You cannot chat while in PlaySolo mode. Use /playsolo lurk to chat.");
            event.setCancelled(true);
            return;
        }
        Iterator recipients = event.getRecipients().iterator();
        while (recipients.hasNext()) {
            Player recipient = (Player)recipients.next();
            if (recipient.equals((Object)sender)) continue;
            PlaySoloMode recipientMode = this.playSoloManager.getSoloMode(recipient);
            if (recipient.hasPermission("playsolo.bypass")) continue;
            if (recipientMode == PlaySoloMode.ON) {
                recipients.remove();
                continue;
            }
            if (recipientMode == PlaySoloMode.LURK && senderMode != null) {
                recipients.remove();
                continue;
            }
            if (recipientMode != null || senderMode != PlaySoloMode.ON) continue;
            recipients.remove();
        }
    }
}

