/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.playsolo.data;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.bukkit.entity.Player;
import ws.hypha.playsolo.PlaySoloPlugin;
import ws.hypha.playsolo.data.PlaySoloMode;

public class PlaySoloManager {
    private final PlaySoloPlugin plugin;
    private Connection connection;
    private final Map<UUID, PlaySoloMode> soloPlayersCache = new ConcurrentHashMap<UUID, PlaySoloMode>();

    public PlaySoloManager(PlaySoloPlugin plugin) {
        this.plugin = plugin;
    }

    public void initialize() {
        try {
            if (!this.plugin.getDataFolder().exists()) {
                this.plugin.getDataFolder().mkdirs();
            }
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.plugin.getDataFolder().getAbsolutePath() + "/playsolo.db");
            try (Statement statement = this.connection.createStatement();){
                statement.execute("CREATE TABLE IF NOT EXISTS solo_players (uuid TEXT PRIMARY KEY, mode TEXT NOT NULL)");
            }
            this.plugin.getLogger().info("Database connection established.");
        }
        catch (ClassNotFoundException | SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to initialize database", e);
        }
    }

    public void close() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
                this.plugin.getLogger().info("Database connection closed.");
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error closing database connection", e);
        }
    }

    public void loadPlayer(Player player) {
        UUID playerUUID = player.getUniqueId();
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT mode FROM solo_players WHERE uuid = ?");){
            ps.setString(1, playerUUID.toString());
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                PlaySoloMode mode = PlaySoloMode.valueOf(rs.getString("mode"));
                this.soloPlayersCache.put(playerUUID, mode);
                this.plugin.getLogger().info("Loaded solo status for " + player.getName() + ": " + String.valueOf((Object)mode));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error loading player data for " + player.getName(), e);
        }
    }

    public void unloadPlayer(Player player) {
        this.soloPlayersCache.remove(player.getUniqueId());
    }

    public void setSoloMode(Player player, PlaySoloMode mode) {
        UUID playerUUID = player.getUniqueId();
        if (mode == null) {
            this.soloPlayersCache.remove(playerUUID);
            try (PreparedStatement ps = this.connection.prepareStatement("DELETE FROM solo_players WHERE uuid = ?");){
                ps.setString(1, playerUUID.toString());
                ps.executeUpdate();
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Error removing player solo status for " + player.getName(), e);
            }
        } else {
            this.soloPlayersCache.put(playerUUID, mode);
            try (PreparedStatement ps = this.connection.prepareStatement("INSERT OR REPLACE INTO solo_players (uuid, mode) VALUES (?, ?)");){
                ps.setString(1, playerUUID.toString());
                ps.setString(2, mode.name());
                ps.executeUpdate();
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Error setting player solo status for " + player.getName(), e);
            }
        }
    }

    public PlaySoloMode getSoloMode(Player player) {
        return this.soloPlayersCache.get(player.getUniqueId());
    }

    public boolean isSolo(Player player) {
        return this.soloPlayersCache.containsKey(player.getUniqueId());
    }

    public Map<UUID, PlaySoloMode> getSoloPlayers() {
        return this.soloPlayersCache;
    }
}

