/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.playsolo.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import ws.hypha.playsolo.PlaySoloPlugin;
import ws.hypha.playsolo.data.PlaySoloManager;
import ws.hypha.playsolo.data.PlaySoloMode;
import ws.hypha.playsolo.manager.PlayerVisibilityManager;

public class PlaySoloCommand
implements CommandExecutor,
TabCompleter {
    private final PlaySoloManager playSoloManager;
    private final PlayerVisibilityManager visibilityManager;

    public PlaySoloCommand(PlaySoloPlugin plugin) {
        this.playSoloManager = plugin.getPlaySoloManager();
        this.visibilityManager = plugin.getVisibilityManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                sender.sendMessage((Component)Component.text((String)"This command can only be used by a player.", (TextColor)NamedTextColor.RED));
                return true;
            }
            Player player = (Player)sender;
            this.toggleSoloMode(player);
            return true;
        }
        if (args.length == 1) {
            String subCommand = args[0].toLowerCase();
            if (Arrays.asList("on", "off").contains(subCommand)) {
                if (!(sender instanceof Player)) {
                    sender.sendMessage((Component)Component.text((String)"This command can only be used by a player.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                this.setPlayerSoloMode((Player)sender, subCommand);
                return true;
            }
        }
        if (args.length == 2) {
            if (!sender.hasPermission("playsolo.command.others")) {
                sender.sendMessage((Component)Component.text((String)"You do not have permission to change other players' solo mode.", (TextColor)NamedTextColor.RED));
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[0]);
            if (target == null) {
                sender.sendMessage((Component)Component.text((String)"Player not found.", (TextColor)NamedTextColor.RED));
                return true;
            }
            String subCommand = args[1].toLowerCase();
            if (!Arrays.asList("on", "off").contains(subCommand)) {
                sender.sendMessage((Component)Component.text((String)"Invalid mode. Use on or off.", (TextColor)NamedTextColor.RED));
                return true;
            }
            this.setPlayerSoloMode(target, subCommand, sender);
            return true;
        }
        this.sendUsage(sender);
        return true;
    }

    private void toggleSoloMode(Player player) {
        PlaySoloMode currentMode = this.playSoloManager.getSoloMode(player);
        if (currentMode == PlaySoloMode.ON) {
            this.playSoloManager.setSoloMode(player, null);
            player.sendMessage((Component)Component.text((String)"PlaySolo mode disabled.", (TextColor)NamedTextColor.GREEN));
        } else {
            this.playSoloManager.setSoloMode(player, PlaySoloMode.ON);
            player.sendMessage((Component)Component.text((String)"PlaySolo mode enabled.", (TextColor)NamedTextColor.GREEN));
        }
        this.visibilityManager.updateVisibilityForPlayer(player);
    }

    private void setPlayerSoloMode(Player player, String modeStr) {
        this.setPlayerSoloMode(player, modeStr, (CommandSender)player);
    }

    private void setPlayerSoloMode(Player player, String modeStr, CommandSender initiator) {
        Object message;
        PlaySoloMode mode = null;
        switch (modeStr) {
            case "on": {
                mode = PlaySoloMode.ON;
                break;
            }
            case "off": {
                mode = null;
            }
        }
        this.playSoloManager.setSoloMode(player, mode);
        this.visibilityManager.updateVisibilityForPlayer(player);
        if (initiator == player) {
            message = "PlaySolo mode " + (mode != null ? "enabled." : "disabled.");
        } else {
            String modeString = mode == null ? "OFF" : mode.toString();
            message = String.format("%s is now in solo mode %s.", player.getName(), modeString);
        }
        initiator.sendMessage((Component)Component.text((String)message, (TextColor)NamedTextColor.GREEN));
        if (initiator != player) {
            String targetModeString = mode == null ? "OFF" : mode.toString();
            player.sendMessage((Component)Component.text((String)String.format("Your solo mode has been set to %s by %s.", targetModeString, initiator.getName()), (TextColor)NamedTextColor.AQUA));
        }
    }

    private void sendUsage(CommandSender sender) {
        sender.sendMessage((Component)Component.text((String)"Usage: /playsolo [on|off] | /playsolo <player> [on|off]", (TextColor)NamedTextColor.RED));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        Player target;
        if (args.length == 1) {
            ArrayList<String> suggestions = new ArrayList<String>();
            if (sender instanceof Player) {
                Player player = (Player)sender;
                PlaySoloMode currentMode = this.playSoloManager.getSoloMode(player);
                if (currentMode != PlaySoloMode.ON) {
                    suggestions.add("on");
                }
                if (currentMode != null) {
                    suggestions.add("off");
                }
            }
            if (sender.hasPermission("playsolo.command.others")) {
                suggestions.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList()));
            }
            return suggestions.stream().filter(s -> s.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2 && sender.hasPermission("playsolo.command.others") && (target = Bukkit.getPlayer((String)args[0])) != null) {
            ArrayList<String> suggestions = new ArrayList<String>();
            PlaySoloMode currentMode = this.playSoloManager.getSoloMode(target);
            if (currentMode != PlaySoloMode.ON) {
                suggestions.add("on");
            }
            if (currentMode != null) {
                suggestions.add("off");
            }
            return suggestions.stream().filter(s -> s.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

