/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.playsolo;

import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import ws.hypha.playsolo.commands.PlaySoloCommand;
import ws.hypha.playsolo.data.PlaySoloManager;
import ws.hypha.playsolo.listeners.PlayerChatListener;
import ws.hypha.playsolo.listeners.PlayerConnectionListener;
import ws.hypha.playsolo.manager.PlayerVisibilityManager;

public class PlaySoloPlugin
extends JavaPlugin {
    private PlaySoloManager playSoloManager;
    private PlayerVisibilityManager visibilityManager;

    public void onEnable() {
        this.saveDefaultConfig();
        this.playSoloManager = new PlaySoloManager(this);
        this.playSoloManager.initialize();
        this.visibilityManager = new PlayerVisibilityManager(this, this.playSoloManager);
        PlaySoloCommand playSoloCommand = new PlaySoloCommand(this);
        this.getCommand("playsolo").setExecutor((CommandExecutor)playSoloCommand);
        this.getCommand("playsolo").setTabCompleter((TabCompleter)playSoloCommand);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerConnectionListener(this.playSoloManager, this.visibilityManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerChatListener(this.playSoloManager), (Plugin)this);
        this.getLogger().info("PlaySolo plugin has been enabled!");
    }

    public void onDisable() {
        if (this.playSoloManager != null) {
            this.playSoloManager.close();
        }
        this.getLogger().info("PlaySolo plugin has been disabled!");
    }

    public PlaySoloManager getPlaySoloManager() {
        return this.playSoloManager;
    }

    public PlayerVisibilityManager getVisibilityManager() {
        return this.visibilityManager;
    }
}

